/*
SCPodcast: automated podcasting with SuperCollider.
(c) 2007 Dan Stowell.

test code:
p = SCPodcast(SCPodcast.classdir ++ "/test/read", SCPodcast.classdir ++ "/test/write", "http://localhost/~dan/scpodcasttest1", 6, "scpodcast-", "scpodcast_harp1.osc");
p.generate;
p.audiofiles;

p.shellCmd
*/
SCPodcast {
	
	classvar <classdir;
	
	var <>readdir, <>writedir, <>baseurl, <>maxentries, <>mp3prefix, <>oscfname, <>itemtitleprefix;
	
	*initClass {
		classdir = this.filenameSymbol.asString.dirname;
	}
	
	*new { |readdir, writedir, baseurl, maxentries=6, mp3prefix="scpodcast-", oscfname, itemtitleprefix=""|
		^super.newCopyArgs(readdir, writedir, baseurl, maxentries, mp3prefix, oscfname, itemtitleprefix);
	}
	
	/**
	* Runs the OSC file to create a new audio file, then updates RSS feed
	*/
	generate { |action| // |readdir, writedir, baseurl, maxentries, mp3prefix, oscfname|
		var scriptpath, cmd, result, timer;
		if(File.exists(readdir ++ "/" ++ oscfname).not, {
			"Please create the OSC file first".postln;
			oscfname.postln;
			^this;
		});
		timer = Date.localtime.secStamp.asInteger;
		this.checkRssTop;
		cmd = this.shellCmd;
		//("COMMAND:\n"++cmd).postln;
		result = cmd.unixCmdThen({ |pid|
			timer = Date.localtime.secStamp.asInteger - timer;
			"---------------------------".postln;
			"SCPodcast:generate complete".postln;
			("Took" + (timer/60) + "mins").postln;
			"---------------------------".postln;
			action.value(writedir ++ "/podcast.rss");
		}, 15);
		^result;
	}
	
	shellCmd {
		var scriptpath = classdir ++ "/scpodcast.bash";
		^["bash", scriptpath, readdir, writedir, baseurl, maxentries, mp3prefix, oscfname, itemtitleprefix]
				.collect({|item| item.asString.escapeChar($ )}).join(" ");
	}
	
	// Simplistic convenience method to find audio files assumed to have been generated by the current SCPodcast
	audiofiles {
		^(writedir ++ "/" ++ mp3prefix ++ "*.mp3").pathMatch;
	}
	
	// Will generate automatically an RSS top for you if neccessary
	checkRssTop {
		if(File.exists(readdir ++ "/rsstop.txt").not, {
			/*
			* GENERATE STRING USING OSCFNAME? MP3PREFIX?
			* THEN WRITE TO FILE
			*/
			File(readdir ++ "/rsstop.txt", "w").write(
			"<?xml version=\"1.0\" ?>
<!-- <?xml-stylesheet href=\"rss.css\" type=\"text/css\"?> -->
<rss version=\"2.0\">
        <channel>
                <title>SCPodcast: "++oscfname++"</title>
                <link>http://supercollider.sourceforge.net/</link>
                <description>A podcast automatically generated using SuperCollider and SCPodcast</description>
                <language>en-uk</language>
                <copyright>The audio files are published under the Creative Commons BY-NC-SA 2.0 license http://creativecommons.org/licenses/by-nc-sa/2.0/</copyright>
").close;
			"Generated default rsstop.txt".postln;
		});
	}
}